' La caractristique sommet.
public interface IPointy
    Function GetNumberOfPoints() As Byte
    ' Les interfaces peuvent aussi avoir des proprits...
    ' Property Points() As Byte
end interface 

' Comportement du dessin 3D.
public interface IDraw3D
    Sub Draw()
End interface

' Classe de base.
Public MustInherit Class Shape
    Protected Name As String

    ' Constructeurs.
    Public Sub New()
        PetName = "Pas_de_nom"
    End Sub

    Public Sub New(ByVal s As String)
        Me.petName = s
    End Sub

    ' Chaque enfant doit dfinir par lui-mme ce que cela
    ' signifie d'tre dessin.
    Public MustOverride Sub Draw()

    Public Property PetName() As String
        Get
            Return Name
        End Get
        Set(ByVal Value As String)
            Name = Value
        End Set
    End Property
End Class 

Public Class Circle
    Inherits Shape
    Implements IDraw3D

    Public Sub New()
    End Sub

    ' Appelle le constructeur de la classe de base.
    Public Sub New(ByVal name As String)
        MyBase.New(name)
    End Sub

    Public Overrides Sub Draw()
        Console.WriteLine("Dessin de " & PetName & " le cercle")
    End Sub

    Private Sub iftImplDraw() Implements IDraw3D.Draw
        Console.WriteLine("Dessin d'un cercle en 3D!")
    End Sub
End Class

Public Class Hexagon
    Inherits Shape
    Implements IPointy, IDraw3D

    Public Sub New()
    End Sub

    Public Sub New(ByVal name As String)
        MyBase.new(name)
    End Sub

    Public Overrides Sub Draw()
        Console.WriteLine("Dessin de " & PetName & " l'hexagone")
    End Sub

    Public Function GetNumberOfPoints() As Byte _
        Implements IPointy.GetNumberOfPoints
        Return 6
    End Function

    Private Sub iftImplDraw() Implements IDraw3D.Draw
        Console.WriteLine("Dessin de l'hexagone en 3D!")
    End Sub
End Class

Public Class Triangle
    Inherits Shape
    Implements IPointy

    Public Sub New(ByVal name As String)
        MyBase.New(name)
    End Sub

    Public Sub New()
    End Sub

    Public Overrides Sub Draw()
        Console.WriteLine("Dessin de " & PetName & " le triangle")
    End Sub

    Public Function GetNumberOfPoints() As Byte _
    Implements IPointy.GetNumberOfPoints
        Return 3
    End Function
End Class

Public Class Oval
    Inherits Circle
    Public Sub New()
        MyBase.PetName = "Joe"
    End Sub
End Class

Public Class Line
    Inherits Shape
    Implements IDraw3D

    Private Sub iftImplDraw() Implements IDraw3D.Draw
        Console.WriteLine("Dessin d'une ligne en 3D...")
    End Sub
    Public Overrides Sub Draw()
        Console.WriteLine("Dessin d'une ligne...")
    End Sub
End Class
